define(['angular', 'app','WeightFHIRService', 'BpPulseFHIRService', 'GlucoseFHIRService','CholesterolFHIRService','MoodFHIRService','FitnessActivityFHIRService','FitnessGoalsFHIRService'], function (angular, app) {
	"use strict";

    app.service('TrackersService', function (WeightFHIRService, BpPulseFHIRService, GlucoseFHIRService, CholesterolFHIRService, MoodFHIRService, FitnessActivityFHIRService,FitnessGoalsFHIRService) {
		var TrackersService = {};
		TrackersService.instances = {};

		TrackersService.instance = function (key) {

			if (!TrackersService.instances[key]) {
				switch (key) {
					case 'bp-pulse':
						TrackersService.instances[key] = BpPulseFHIRService;
						break;
					case 'weight': 
						TrackersService.instances[key] = WeightFHIRService;
						break;
					case 'glucose':
						TrackersService.instances[key] = GlucoseFHIRService;
						break;
                    case 'cholesterol':
                        TrackersService.instances[key] = CholesterolFHIRService;
                        break;
                    case 'mood':
                        TrackersService.instances[key] = MoodFHIRService;
                        break;
                    case 'fitness-activity':
                        TrackersService.instances[key] = FitnessActivityFHIRService;
                        break;
                    case 'fitness-goals':
                        TrackersService.instances[key] = FitnessGoalsFHIRService;
                        break;

				}
			}

			return TrackersService.instances[key];
		}

		return TrackersService;
	});
});